<?php
//get all companies
//add new company
//get one company
//edit company


class Companies extends Controller {
    private $currentModel;
    private $facilityModel;
    private $privateLabelModel;
    private $contactModel;

    public function __construct(){
        $this->currentModel = $this->model('Company');
        $this->connectModels();
    }

    public function connectModels(){
        $this->facilityModel=$this->model('Facility');
        $this->privateLabelModel=$this->model('PrivateLabel');
        $this->contactModel=$this->model('Contact');
    }

//See all companies' basic info. used only by user
    public function viewCompanies()
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $companies = $this->currentModel->viewCompanies();

                if ($companies) {
                    echo json_encode($companies);

                } else {
                    echo json_encode(['success' => false]);
                }

            }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);
        }


    }

    //see one companys info with pl and facility and contacts for both user and contact
    public function viewCompany($company_id = 0)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $company_id
                ];
            }elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $id
                ];
            }
            if($data){


                $company = $this->currentModel->viewCompany($data);


                if ($company) {
                    echo json_encode($company);
                } else {
                    echo json_encode(['success' => false]);
                }
            }  else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }

    // Create a new company, only the user can do this

    public function createCompany()
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_name' => $_POST['company_name'],
                    'company_code' => $_POST['company_code'],
                    'company_note' => $_POST['company_note'],

                ];
                if ($this->currentModel->createCompany($data)) {
                    $this->viewCompanies();
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }


    // put in or edit the companies info, only the contact

    public function editCompanyInfo()
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {


                $data = [
                    'company_id' => $id,
                    'company_name' => $_POST['company_name'],
                    'company_address1' => $_POST['company_address1'],
                    'company_address2' => $_POST['company_address2'],
                    'company_city' => $_POST['company_city'],
                    'company_province' => $_POST['company_province'],
                    'company_postal_code' => $_POST['company_postal_code'],
                    'company_country' => $_POST['company_country'],
                    'company_phone' => $_POST['company_phone'],
                    'company_fax' => $_POST['company_fax'],
                    'company_email' => $_POST['company_email'],
                    'company_website' => $_POST['company_website']

                ];

                if ($this->currentModel->editCompanyInfo($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }

    // to add some extra info about a company, user

    public function editCompanyComment($company_id)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'company_id' => $company_id,
                    'company_note' => $_POST['company_note']
                ];

                if ($this->currentModel->editCompanyComment($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //find product from whole list, user
    public function findCompany(){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'company_name' => $_POST['company_name']
        ];

        $companies = $this->currentModel->findCompany($data);

        if($companies){
            echo json_encode($companies);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
}



