<?php

//get all contacts for one company
//get one contact
//get all contacts
//edit contact
//delete contact

class Contacts extends Controller {
    private $currentModel;

    public function  __construct() {
        $this->currentModel = $this->model('Contact');
    }
    //this function returns all contacts for a single company. used by both user and contact.
    public function viewCompanyContacts($company_id = 0) {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
            'company_id' => $company_id

        ];
      } elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $id
                ];
            }
            if($data) {
                $contacts = $this->currentModel->viewCompanyContacts($data);

        if($contacts) {
            echo json_encode($contacts);
        } else {
            echo json_encode(['success' => false]);
        }

        } else {
            echo json_encode(['success' => false, 'error' => "invalid token"]);
        }

    } else {
echo json_encode(['success' => false, 'error' => "token undefined"]);

}

}
    //this function returns all contacts for all companies. used by user.
    public function viewAllContacts() {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {


        $contacts = $this->currentModel->viewAllContacts();

        if($contacts) {
            echo json_encode($contacts);
        } else {
            echo json_encode(['success' =>false]);
        }

    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }


    //this function returns all information on a single contact. used by contact.
    public function viewContact($contact_id) {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
          'contact_id' => $contact_id
        ];
        $contacts = $this->currentModel->viewContact($data);

        if($contacts)  {
            echo json_encode($contacts);
        } else {
            echo json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function creates a new contact. used by contact
    public function createContact() {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
          'contact_first_name' => $_POST['contact_first_name'],
          'contact_last_name' => $_POST['contact_last_name'],
          'contact_title' => $_POST['contact_title'],
          'contact_phone' => $_POST['contact_phone'],
          'contact_email' => $_POST['contact_email'],
          'contact_username' => $_POST['contact_username'],
          'contact_password' => $_POST['contact_password'],
          'company_id' => $id
        ];

        if($this->currentModel->createContact($data)) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => 'contact already exisits']);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function is to edit an existing contact. used by contact.
    public function editContact($contact_id) {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
            'contact_id' => $contact_id,
            'contact_first_name' => $_POST['contact_first_name'],
            'contact_last_name' => $_POST['contact_last_name'],
            'contact_title' => $_POST['contact_title'],
            'contact_phone' => $_POST['contact_phone'],
            'contact_email' => $_POST['contact_email'],
            'contact_username' => $_POST['contact_username'],
            'contact_password' => $_POST['contact_password'],

            ];

        if($this->currentModel->editContact($data)) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);

        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function is to delete an existing contact. used by contact

    public function deleteContact($contact_id) {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'contact_id' => $contact_id
        ];

        $contact = $this->currentModel->deleteContact($data);

        if($contact) {
            echo json_encode(['success => true']);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

}

