<?php
//get all facilities for one company done
//get all facilities done
//get one facility done
//edit facility done
//add facility done
//delete facility done
//delete company
//save company info as facility

class Facilities extends Controller
{
    private $currentModel;

    public function __construct()
    {
        $this->currentModel = $this->model('Facility');
    }

    //this function returns all facilities for a single company user and contact
    public function viewCompanyFacilities($company_id = 0)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $company_id
                ];
            }elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $id
                ];
            }
            if($data){
                $facilities = $this->currentModel->viewCompanyFacilities($data);

                if ($facilities) {
                    echo json_encode($facilities);
                } else {
                    echo json_encode(['success' => false]);
                }

            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //this function returns basic info on all facilities, user
    public function viewFacilities()
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $facilities = $this->currentModel->viewFacilities();

                if ($facilities) {
                    echo json_encode($facilities);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //this function returns all information on a single facility, user and contact
    public function viewFacility($facility_id)
    {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'facility_id' => $facility_id
                ];
                $facilities = $this->currentModel->viewFacility($data);

                if ($facilities) {
                    echo json_encode($facilities);
                } else {
                    echo json_encode(['success' => false]);
                }

            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }


    //this function is to create a new facility, contact
    public function createFacility()
    {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'facility_name' => $_POST['facility_name'],
                    'facility_address1' => $_POST['facility_address1'],
                    'facility_address2' => $_POST['facility_address2'],
                    'facility_city' => $_POST['facility_city'],
                    'facility_province' => $_POST['facility_province'],
                    'facility_postal_code' => $_POST['facility_postal_code'],
                    'facility_country' => $_POST['facility_country'],
                    'facility_phone' => $_POST['facility_phone'],
                    'company_id' => $id,
                ];
                if ($this->currentModel->createFacility($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false, 'error' => 'facility already exists']);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }
        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);
        }
    }
    //this function is to edit an existing facility, contact
    public function editFacility($facility_id)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [

                    'facility_id' => $facility_id,
                    'facility_name' => $_POST['facility_name'],
                    'facility_address1' => $_POST['facility_address1'],
                    'facility_address2' => $_POST['facility_address2'],
                    'facility_city' => $_POST['facility_city'],
                    'facility_province' => $_POST['facility_province'],
                    'facility_postal_code' => $_POST['facility_postal_code'],
                    'facility_country' => $_POST['facility_country'],
                    'facility_phone' => $_POST['facility_phone'],
                ];

                if ($this->currentModel->editFacility($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }


    //This function is to delete a facility, first it will make sure that the facility is not in use anywhere, contact
    public function deleteFacility($facility_id)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'facility_id' => $facility_id
                ];

                $facility = $this->currentModel->deleteFacility($data);

                if ($facility) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //on contact side could check off to save companies info into facility table also
    public function saveCompanyAsFacility($company_id)
    {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [

                    'company_name' => $_POST['company_name'],
                    'company_address1' => $_POST['company_address1'],
                    'company_address2' => $_POST['company_address2'],
                    'company_city' => $_POST['company_city'],
                    'company_province' => $_POST['company_province'],
                    'company_postal_code' => $_POST['company_postal_code'],
                    'company_country' => $_POST['company_country'],
                    'company_phone' => $_POST['company_phone'],
                    'company_id' => $company_id,
                ];

                if ($this->currentModel->saveCompanyAsFacility($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }

            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
}




