<?php
//get all ingredients (which company added it)
//get all ingredients within company
//get one ingredient
//add ingredient
//edit ingredient
//delete ingredient

class Ingredients extends Controller {
    private $currentModel;

    public function  __construct() {
        $this->currentModel = $this->model('Ingredient');
    }

    //View all ingredients, user

    public function viewIngredients(){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $ingredients = $this->currentModel->viewIngredients();

        if($ingredients){
            echo json_encode($ingredients);
        } else {
            echo json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //view ingredients that were not approved/rejected
    public function viewWorkflowIngredients(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $ingredients = $this->currentModel->viewWorkflowIngredients();

                if($ingredients){
                    echo json_encode($ingredients);
                } else {
                    echo json_encode(['success' => false]);
                }
            }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }

    //view all ingredients submitted by one company, contact and user

    public function viewCompanyIngredients($company_id = 0){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
            'company_id' => $company_id
        ];

    } elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
            'company_id' => $id
        ];
    }

        if($data) {

        $ingredients = $this->currentModel->viewCompanyIngredients($data);

        if($ingredients){
            echo json_encode($ingredients);
        } else {
            echo json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }



    //view a specific products ingredients, contact, only if its from their list and user

    public function viewProductIngredients($product_id){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_id' => $product_id
        ];

        $ingredients = $this->currentModel->viewProductIngredients($data);

        if($ingredients){
            echo json_encode($ingredients);
        } else {
            json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }


    //view details about one specific ingredient, user and contact only if its from their list

    public function viewIngredient($ingredient_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_id' => $ingredient_id
        ];

        $ingredient = $this->currentModel->viewIngredient($data);

        if($ingredient){
            echo json_encode($ingredient);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //create a new ingredient, contact

    public function createIngredient(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_name' => $_POST['ingredient_name'],
            'vendor_name' => $_POST['vendor_name'],
            'company_id' => $id
        ];

        if($this->currentModel->createIngredient($data)){
            echo json_encode(['success'=> true]);
        } else {
            echo json_encode(['success'=> false, 'error' => 'ingredient already exists']);
            }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //edit the ingredients information, contact

    public function editIngredientInfo($ingredient_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_name' => $_POST['ingredient_name'],
            'vendor_name' => $_POST['vendor_name'],
            'ingredient_id' => $ingredient_id
        ];

        if($this->currentModel->editIngredientInfo($data)){
            echo json_encode(['success'=> true]);
        } else {
            echo json_encode(['success'=> false]);
            }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //approve or not as vegan and why, user
    public function editIngredientStatus($ingredient_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'ingredient_eval_status' => $_POST['ingredient_eval_status'],
            'ingredient_eval_date' => $_POST['ingredient_eval_date'],
            'ingredient_note' => $_POST['ingredient_note'],
            'user_id' => $id,
            'ingredient_id' => $ingredient_id
        ];

        if($this->currentModel->editIngredientStatus($data)){
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    public function editIngredientNote($ingredient_id){
        if (isset($GLOBALS['headers']['Authorization'])){
            if($id = $this->verifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'ingredient_note' => $_POST['ingredient_note'],
                    'user_id' => $id,
                    'ingredient_id' => $ingredient_id
                ];

                if($this->currentModel->editIngredientNote($data)){
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }

    //delete an ingredient, contact

    public function deleteIngredient($ingredient_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_id' => $ingredient_id
        ];

        $ingredient = $this->currentModel->deleteIngredient($data);

        if($ingredient){
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
         }
        }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

        //contact could check to take product info and save it into their lists of ingredients
        public function createProductAsIngredient($company_id){
            if (isset($GLOBALS['headers']['Authorization'])) {
                if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'company_id' => $company_id,
            'product_name' => $_POST['product_name'],
            'company_name' => $_POST['company_name']
        ];

        if($this->currentModel->createProductAsIngredient($data)){
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
            }
        }
                else {
                    echo json_encode(['success' => false, 'error' => "invalid token"]);
                }

            } else {
                echo json_encode(['success' => false, 'error' => "token undefined"]);

            }

        }

        //find ingredient from whole list, user
    public function findIngredient(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
            'ingredient_name' => $_POST['ingredient_name']
        ];

        $ingredients = $this->currentModel->findIngredient($data);

        if($ingredients){
            echo json_encode($ingredients);
        } else {
            echo json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    public function findIngredientById(){
        if(isset($GLOBALS['headers']['Authorization'])){
            if($id = $this->verifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'ingredient_id' => $_POST['ingredient_id']
                ];

                $ingredients = $this->currentModel->findIngredientById($data);

                if($ingredients){
                    echo json_encode($ingredients);
                } else {
                    json_encode(['success'=> false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }
        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);
        }
    }

    //find ingredient within one companys list, user and contact
    public function findCompanyIngredient($company_id = 0){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_name' => $_POST['ingredient_name'],
            'company_id' => $company_id
        ];

    }elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'ingredient_name' => $_POST['ingredient_name'],
            'company_id' => $id

    ];
    }
    if($data) {
        $ingredients = $this->currentModel->findCompanyIngredient($data);

   

        if($ingredients){
            echo json_encode($ingredients);
        } else {
            echo json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

}

