<?php
//get all pbc's for one company done
//get all pbc's done
//get one pbc's done
//edit pbc's
//add pbc's
//delete pbc's

class PrivateLabels extends Controller {
    private $currentModel;

    public function __construct()
    {
        $this->currentModel = $this->model('PrivateLabel');
    }
    //this function returns all pbc's (private label companies) for a specific company, user and contact
    public function viewCompanyPrivateLabels($company_id = 0){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $company_id
                ];
            }elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [
                    'company_id' => $id
                ];
            }
            if($data){
        $privateLabels = $this->currentModel->viewCompanyPrivateLabels($data);

        if($privateLabels) {
            echo json_encode($privateLabels);
        } else {
            json_encode(['success' => false]);
        }

    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function returns info on all private label companies, user
    public function viewPrivateLabels() {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $privateLabels = $this->currentModel->viewPrivateLabels();

        if($privateLabels) {
            echo json_encode($privateLabels);
        } else {
            json_encode(['success' => false]);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function returns info on a single private label company, user and contact
    public function viewPrivateLabel($pl_id) {

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
          'pl_id' => $pl_id
        ];
        $pl_companies = $this->currentModel->ViewPrivateLabel($data);

        if($pl_companies) {
            echo json_encode($pl_companies);
         } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }
    //this function is for adding a new private label company, contact
    public function createPrivateLabel() {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'pl_name' => $_POST['pl_name'],
            'pl_address1' => $_POST['pl_address1'],
            'pl_address2' => $_POST['pl_address2'],
            'pl_city' => $_POST['pl_city'],
            'pl_province' => $_POST['pl_province'],
            'pl_postal_code' => $_POST['pl_postal_code'],
            'pl_country' => $_POST['pl_country'],
            'pl_phone' => $_POST['pl_phone'],
            'pl_fax' => $_POST['pl_fax'],
            'pl_email' => $_POST['pl_email'],
            'pl_website' => $_POST['pl_website'],
            'pl_brand' => $_POST['pl_brand'],
            'company_id' => $id,
        ];

        if($this->currentModel->createPrivateLabel($data)) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }

    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    public function editPrivateLabel($pl_id) {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

                $data = [

                    'pl_id' => $pl_id,
                    'pl_name' => $_POST['pl_name'],
                    'pl_address1' => $_POST['pl_address1'],
                    'pl_address2' => $_POST['pl_address2'],
                    'pl_city' => $_POST['pl_city'],
                    'pl_province' => $_POST['pl_province'],
                    'pl_postal_code' => $_POST['pl_postal_code'],
                    'pl_country' => $_POST['pl_country'],
                    'pl_phone' => $_POST['pl_phone'],
                    'pl_fax' => $_POST['pl_fax'],
                    'pl_email' => $_POST['pl_email'],
                    'pl_website' => $_POST['pl_website'],
                    'pl_brand' => $_POST['pl_brand'],
                ];

                if ($this->currentModel->editPrivateLabel($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

// delete the private label only if its not in use, contact
    public function deletePrivateLabel($pl_id) {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'pl_id' => $pl_id
        ];

        $pl_companies = $this->currentModel->deletePrivateLabel($data);

        if($pl_companies) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

}
