<?php
//get all products (which company added it)
//get all products within company
//get all products within facility
//get all products within private label
//get one product (get all ingredients within that product)
//add product
//edit product
//delete product (first have to delete all references in formula

class Products extends Controller
{
    private $currentModel;
    private $ingredientModel;

    public function __construct()
    {
        $this->currentModel = $this->model('Product');
        $this->connectModels();
    }

    public function connectModels(){
        $this->ingredientModel = $this->model('Ingredient');
    }

    //view the info about one specific product, contact and user
    public function viewProduct($product_id){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'product_id' => $product_id
        ];

        $product = $this->currentModel->viewProduct($data);

        if($product){
            echo json_encode($product);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    // view all products, user

    public function viewProducts(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $products = $this->currentModel->viewProducts();

        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    // view all products which have not yet been evaluated
    public function viewWorkflowProducts(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $products = $this->currentModel->viewWorkflowProducts();

                if($products){
                    echo json_encode($products);
                } else {
                    echo json_encode(['success' => false]);
                }
            }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
    }

    //view all products made by one company, user and contact
    public function viewCompanyProducts($company_id=0){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'company_id' => $company_id
        ];

    } elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'company_id' => $id
         ];
        }
        if($data) {
            

        $products = $this->currentModel->viewCompanyProducts($data);
        
        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //view all products made in one facility, user and contact
    public function viewFacilityProducts($facility_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'facility_id' => $facility_id
        ];

        $products = $this->currentModel->viewFacilityProducts($data);
        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

//view all products made by one pl, user and contact
    public function viewPLProducts($pl_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {

        $data = [
            'pl_id' => $pl_id
        ];

        $products = $this->currentModel->viewPLProducts($data);
        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

//create a new product, contact
public function createProduct(){
    if (isset($GLOBALS['headers']['Authorization'])) {
        if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
    $data = [
        'company_id' => $id,
        'product_name' => $_POST['product_name'],
        'product_brand' => $_POST['product_brand'],
        'facility_id' => $_POST['facility_id'],
        'pl_id' => (!empty($_POST['pl_id'])) ? $_POST['pl_id'] : null
    ];
    if($this->currentModel->createProduct($data)){
            $product_id = $this->currentModel->getProductID($data);
            echo json_encode($product_id);
    } else {
        echo json_encode(['success'=> false]);
    }
}
        else {
            echo json_encode(['success' => false, 'error' => "invalid token"]);
        }
    } else {
        echo json_encode(['success' => false, 'error' => "token undefined"]);
    }
}

    //part of the process of creating to add the ingredients used  by contact
    public function addIngredientsToProduct($product_id){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $ingredient_id = explode(',', $_POST['ingredient_id']);

        for($i =0; $i< count($ingredient_id); $i++){
            $data = [
                'product_id' => $product_id,
                'ingredient_id' => $ingredient_id[$i]
            ];
            $this->currentModel->addIngredientsToProduct($data);
        }

    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    public function deleteIngredientFromProduct($product_id) {
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $ingredient_id = $_POST['ingredient_id'];
                
                    $data = [
                        'product_id' => $product_id,
                        'ingredient_id' => $ingredient_id
                    ];
      
               $this->currentModel->deleteIngredientFromProduct($data);
               echo json_encode(['success'=> true]);
                                
                }    else {
                    echo json_encode(['success' => false, 'error' => "invalid token"]);
                }
    
            } else {
                echo json_encode(['success' => false, 'error' => "token undefined"]);
    
            }
    
        }
    // edit the products info and or ingredients, automatically loses vegan approval, contact
    public function editProduct($product_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_id' => $product_id,
            'product_name' => $_POST['product_name'],
            'product_brand' => $_POST['product_brand'],
            'facility_id' => $_POST['facility_id'],
            'pl_id' => $_POST['pl_id']
        ];

        if($this->currentModel->editProduct($data)){
        echo json_encode(['success'=> true]);
        } else {
            echo json_encode(['success'=> false]);
            }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }


    //delete the product and all references of it from formulas,contact
    public function deleteProduct($product_id){

        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_id' => $product_id
        ];

        if($this->currentModel->deleteFromFormula($data)){
            if($this->currentModel->deleteProduct($data)){
                json_encode(['success' => true]);
            } else {
                json_encode(['success' => false]);
            }
        } else {
            json_encode(['success' => 'product references in formulas table could not be deleted']);
        }
    }

            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //approve a product and why, user
    public function editProductStatus($product_id){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_eval_status' => $_POST['product_eval_status'],
            'product_eval_date' => $_POST['product_eval_date'],
            'product_note' => $_POST['product_note'],
            'user_id' => $id,
            'product_id' => $product_id
        ];

        if($this->currentModel->editProductStatus($data)){
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    public function editProductNote($product_id){
        if (isset($GLOBALS['headers']['Authorization'])){
            if($id = $this->verifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'product_note' => $_POST['product_note'],
                    'user_id' => $id,
                    'product_id' => $product_id
                ];

                if($this->currentModel->editProductNote($data)){
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }
            }



    //find product from whole list, user
    public function findProduct(){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_name' => $_POST['product_name']
        ];

        $products = $this->currentModel->findProduct($data);

        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }

        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);

        }

    }

    //find product from whole list with id, user
    public function findProductById(){
        if(isset($GLOBALS['headers']['Authorization'])){
            if($id = $this->verifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
                $data = [
                    'product_id' => $_POST['product_id']
                ];

                $products = $this->currentModel->findProductById($data);

                if($products){
                    echo json_encode($products);
                } else {
                    json_encode(['success'=> false]);
                }
            } else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }
        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);
        }
    }

    //find ingredient within one companys list, user and contact
    public function findCompanyProduct($company_id=0){
        if (isset($GLOBALS['headers']['Authorization'])) {
            if ($id = $this->VerifyUserToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_name' => $_POST['product_name'],
            'company_id' => $company_id
        ];
    }elseif ($id = $this->verifyContactToken($GLOBALS['headers']['Authorization'], $_SERVER['REMOTE_ADDR'])) {
        $data = [
            'product_name' => $_POST['product_name'],
            'company_id' => $id
    ];
}
if($data) {
        $products = $this->currentModel->findCompanyProduct($data);
        if($products){
            echo json_encode($products);
        } else {
            echo json_encode(['success' => false]);
        }
    }
            else {
                echo json_encode(['success' => false, 'error' => "invalid token"]);
            }
        } else {
            echo json_encode(['success' => false, 'error' => "token undefined"]);
        }
    }
}