<?php
//add company
//edit company
//delete company

class Register extends Controller {

    private $currentModel;

    public function __construct()
    {
        $this->currentModel = $this->model('SignUp');
    }

    //register contact
    public function contactFind()
    {

        //check for post
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);


            $data = [
                'contact_username' => trim($_POST['contact_username']),
                'company_code' => $_POST['company_code']
            ];
            // checks if username exists, has to be unique
            if (!$this->currentModel->findUserByUsername($data['contact_username'], 'contact')) {

                $company = $this->currentModel->findCompanyCode($data);
                if ($company) {
                    echo json_encode($company);
                    // registers to database, returns true on success or false on failure

                } else {
                    echo json_encode(['error' => 'company does not exist']);
                }
            } else {
                echo json_encode(['error' => 'username taken']);

            }
        }
    }


        public function contactRegister($company_id) {

        $data1 = [
            'company_id' => $company_id,
            'contact_password' => password_hash(trim($_POST['contact_password']), PASSWORD_DEFAULT),
            'contact_first_name' => $_POST['contact_first_name'],
            'contact_last_name' => $_POST['contact_last_name'],
            'contact_title' => $_POST['contact_title'],
            'contact_phone' => $_POST['contact_phone'],
            'contact_email' => $_POST['contact_email'],
            'contact_username' => $_POST['contact_username'],

        ];
//            if (!$this->currentModel->contactFind()) {

                if ($this->currentModel->registerContact($data1)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
//            }  else {
//                echo json_encode(['error' => 'username taken']);
//            }
    }

    public function userRegister() {

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);

            $data = [
            'username' => $_POST['username'],
            'user_password' => password_hash(trim($_POST['user_password']), PASSWORD_DEFAULT),

        ];
            // checks if username exists, has to be unique
            if (!$this->currentModel->findUserByUsername($data['username'], 'user')) {
                // registers to database, returns true on success or false on failure
                if ($this->currentModel->registerUser($data)) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false]);
                }
            } else {
                echo json_encode(['error' => 'username taken']);
                }
             }
    }



}