<?php
declare(strict_types=1);

/*
 * Base Controller
 * Loads the models and views
 */

class Controller{
    //Load model
    public function model($model) {
//        Require model file
        require_once '../app/models/' . $model . '.php';

//        instantiate the model
        return new $model();
    }

    public function verifyToken($token, $ip) {
        $db = new Database();

        $db->query('SELECT * FROM auth WHERE token = :token AND expiry >now()');
        $db->bind(':token', $token);
        //check database if token exists and is not expired
        if($res = $db->single()) {
            // checks if token matches to ip address
            // returns user or contact id if verified else returns false
            if($res->token === $token && $res->ip === $ip) {
                $this->cleanTokens();
                return ($res->user_id > 0) ? $res->user_id : $res->contact_id;
                              
             } else {
                return false;
            }
        } else {
            return false;
        }

    }

    private function cleanTokens() {
        $db = new Database();

        $db->query('DELETE FROM auth WHERE expiry < now()');
        $db->execute();
        unset($db);
    }

    public static function verifyTokenUserType($token, $ip) {
        $db = new Database();

        $db->query('SELECT * FROM auth WHERE token = :token AND expiry > now()');

        $db->bind(':token', $token);
        // check database if token exists and not expired
        if($res = $db->single()) {
            // checks if token matches to ip address
            // returns user or contact id if verified else returns false
            if($res->token === $token && $res->ip === $ip) {    
                return ($res->user_id >0) ? 'user' : 'contact';

            } else {
                return false;
            }
        } else {
                return false;
            }
        }

        private static function updateTokenExpiry($token){
            $db = new Database;
            $db->query("UPDATE auth SET expiry = NOW() + INTERVAL '30 minutes' WHERE token = :token");
            $db->bind(':token', $token);
            $db->execute();
            unset($db);
        }

    public function verifyUserToken($token, $ip) {
        $db = new Database();

        $db->query('SELECT * FROM auth WHERE token = :token AND expiry >now()');

        $db->bind(':token', $token);
        //check database if token exists and is not expired
        if($res = $db->single()) {
            // checks if token matches to ip address
            // returns user or contact id if verified else returns false
            if($res->token === $token && $res->ip === $ip) {
                $this->cleanTokens();
                if($res->user_id >0) {
                    return $res->user_id;
                }
//              
            } else {
                return false;
            }
        } else {
            return false;
        }

    }

    public function verifyContactToken($token, $ip) {
        $db = new Database();

        $db->query('SELECT * FROM auth WHERE token = :token AND expiry >now()');

        $db->bind(':token', $token);
        //check database if token exists and is not expired
        if($res = $db->single()) {
            // checks if token matches to ip address
            // returns user or contact id if verified else returns false
            if($res->token === $token && $res->ip === $ip) {
                $this->cleanTokens();
                if($res->contact_id >0) {
                    return $res->company_id;
                }
            //    return ($res->user_id > 0) ? $res->user_id : $res->contact_id;
            } else {
                return false;
            }
        } else {
            return false;
        }

    }



}