<?php
//Get all companies info
//Get one companies info
//edit company
//delete company
//add company ? should either go here or in sign up

class Company{
    private $db;

    public function __construct(){
        $this->db = new Database;
    }

    public function viewCompanies(){
        $this->db->query("SELECT * FROM companies");

        $results = $this->db->resultSet();
        return $results;
    }

    public function viewCompany($data){
//        $this->db->query('SELECT * FROM companies JOIN facilities ON facilities.company_id = companies.company_id JOIN pl_companies ON pl_companies.company_id = companies.company_id JOIN contacts ON contacts.company_id = companies.company_id WHERE companies.company_id = :company_id');

        $this->db->query('SELECT * FROM companies WHERE company_id = :company_id');

        $this->db->bind(':company_id', $data['company_id']);


        $results = $this->db->resultSet();

        return $results;
    }

    public function createCompany($data){
        $this->db->query('INSERT INTO companies (company_name, company_code, company_note) VALUES (:company_name, :company_code, :company_note)');

        $this->db->bind(':company_name', $data['company_name']);
        $this->db->bind(':company_code', $data['company_code']);
        $this->db->bind(':company_note', $data['company_note']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

//
//    public function createCompany($data){
//        $this->db->query('INSERT INTO companies (company_name, company_code, company_note) VALUES (:company_name, :company_code, :company_note)');
//
//        $this->db->bind(':company_name', $data['company_name']);
//        $this->db->bind(':company_code', $data['company_code']);
//        $this->db->bind(':company_note', $data['company_note']);
//
//        if($this->db->execute()){
//            return true;
//        } else {
//            return false;
//        }
//    }

    public function editCompanyInfo($data){
        $this->db->query('UPDATE companies SET company_name = :company_name, company_address1 = :company_address1, company_address2 = :company_address2, company_city = :company_city, company_province = :company_province, company_postal_code = :company_postal_code, company_country = :company_country, company_phone = :company_phone, company_fax = :company_fax, company_email = :company_email, company_website = :company_website WHERE company_id = :company_id');

        $this->db->bind(':company_name', $data['company_name']);
        $this->db->bind(':company_address1', $data['company_address1']);
        $this->db->bind(':company_address2', $data['company_address2']);
        $this->db->bind(':company_city', $data['company_city']);
        $this->db->bind(':company_province', $data['company_province']);
        $this->db->bind(':company_postal_code', $data['company_postal_code']);
        $this->db->bind(':company_country', $data['company_country']);
        $this->db->bind(':company_phone', $data['company_phone']);
        $this->db->bind(':company_fax', $data['company_fax']);
        $this->db->bind(':company_email', $data['company_email']);
        $this->db->bind(':company_website', $data['company_website']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    public function editCompanyComment($data){
        $this->db->query('UPDATE companies SET company_note = :company_note WHERE company_id = :company_id');

        $this->db->bind(':company_note', $data['company_note']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    public function findCompany($data){
        $this->db->query('SELECT * FROM companies WHERE company_name LIKE :company_name');
        $this->db->bind(':company_name', '%' . $data['company_name'] . '%');

        $results = $this->db->resultSet();
        return $results;
    }


}
