<?php

class Contact {
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }
    //get all contacts for one company
    public function viewCompanyContacts($data) {
        $this->db->query('SELECT contacts.*, companies.company_name FROM contacts INNER JOIN companies ON companies.company_id = contacts.company_id WHERE companies.company_id = :company_id ORDER BY contacts.contact_last_name');

        $this->db->bind(':company_id', $data['company_id']);
        $results = $this->db->resultSet();
        return $results;
    }
    public function viewAllContacts() {
        $this->db->query('SELECT contacts.*, companies.company_name FROM contacts INNER JOIN companies ON companies.company_id = contacts.company_id');

        $results = $this->db->resultSet();
        return $results;

    }

    public function viewContact($data) {
        $this->db->query('SELECT contacts.*, companies.company_name FROM contacts INNER JOIN companies ON companies.company_id = contacts.company_id WHERE contact_id = :contact_id');

        $this->db->bind(':contact_id', $data['contact_id']);

        $results = $this->db->single();

        return $results;
    }

    public function createContact($data) {

        $this->db->query('SELECT * FROM contacts WHERE contact_username =:contact_username && company_id = :company_id');
        $this->db->bind(':contact_username', $data['contact_username']);
        $this->db->bind(':company_id', $data['company_id']);

        $this->db->query('INSERT INTO contacts (contact_first_name, contact_last_name, contact_title, contact_phone, contact_email, contact_username, contact_password, company_id) VALUES (:contact_first_name, :contact_last_name, :contact_title, :contact_phone, :contact_email, :contact_username, :contact_password, :company_id)');

        $this->db->bind(':contact_first_name', $data['contact_first_name']);
        $this->db->bind(':contact_last_name', $data['contact_last_name']);
        $this->db->bind(':contact_title', $data['contact_title']);
        $this->db->bind(':contact_phone', $data['contact_phone']);
        $this->db->bind(':contact_email', $data['contact_email']);
        $this->db->bind(':contact_username', $data['contact_username']);
        $this->db->bind(':contact_password', $data['contact_password']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function editContact($data) {
        $this->db->query('UPDATE contacts SET contact_first_name = :contact_first_name, contact_last_name = :contact_last_name, contact_title = :contact_title, contact_phone = :contact_phone, contact_email = :contact_email, contact_username = :contact_username, contact_password = :contact_password WHERE contact_id = :contact_id');

        $this->db->bind(':contact_id', $data['contact_id']);
        $this->db->bind(':contact_first_name', $data['contact_first_name']);
        $this->db->bind(':contact_last_name', $data['contact_last_name']);
        $this->db->bind(':contact_title', $data['contact_title']);
        $this->db->bind(':contact_phone', $data['contact_phone']);
        $this->db->bind(':contact_email', $data['contact_email']);
        $this->db->bind('contact_username', $data['contact_username']);
        $this->db->bind(':contact_password', $data['contact_password']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function deleteContact($data) {
        $this->db->query('DELETE FROM contacts WHERE contact_id = :contact_id');

        $this->db->bind('contact_id', $data['contact_id']);

        if ($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }
}
//get contacts for one company done
//get all contacts (get which company they belong too) done
//get contact done
//create contact done
//edit contact done
//delete contact done
