<?php
class Facility{
    private $db;

    public function __construct(){
        $this->db = new Database;
    }

    //get all facilities for one company
    public function viewCompanyFacilities($data){
        $this->db->query('SELECT facilities.*, companies.company_name FROM facilities INNER JOIN companies ON companies.company_id = facilities.company_id WHERE companies.company_id = :company_id');
        $this->db->bind(':company_id', $data['company_id']);

        $results = $this->db->resultSet();
        return $results;
    }

    public function viewFacilities() {
        $this->db->query('SELECT facilities.*, companies.company_name FROM facilities INNER JOIN companies ON companies.company_id = facilities.company_id');

        $results = $this->db->resultSet();
        return $results;
    }

    public function viewFacility($data) {
        $this->db->query('SELECT facilities.*, companies.company_name FROM facilities INNER JOIN companies ON companies.company_id = facilities.company_id WHERE facility_id = :facility_id');

        $this->db->bind(':facility_id', $data['facility_id']);

        $results = $this->db->single();

        return $results;
    }

    public function createFacility($data) {

        $this->db->query('SELECT * FROM facilities WHERE facility_address1 = :facility_address1 && company_id = :company_id');
        $this->db->bind(':facility_address1', $data['facility_address1']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->resultSet()){
            return false;
        } else {
            $this->db->query('INSERT INTO facilities (facility_name, facility_address1, facility_address2, facility_city, facility_province, facility_postal_code, facility_country, facility_phone, company_id) VALUES (:facility_name, :facility_address1, :facility_address2, :facility_city, :facility_province, :facility_postal_code, :facility_country, :facility_phone, :company_id)');

            $this->db->bind(':facility_name', $data['facility_name']);
            $this->db->bind(':facility_address1', $data['facility_address1']);
            $this->db->bind(':facility_address2', $data['facility_address2']);
            $this->db->bind(':facility_city', $data['facility_city']);
            $this->db->bind(':facility_province', $data['facility_province']);
            $this->db->bind(':facility_postal_code', $data['facility_postal_code']);
            $this->db->bind(':facility_country', $data['facility_country']);
            $this->db->bind(':facility_phone', $data['facility_phone']);
            $this->db->bind(':company_id', $data['company_id']);

            if($this->db->execute()) {
                return true;
            } else {
                return false;
            }

        }

      }

    public function editFacility($data)
    {
        $this->db->query('UPDATE facilities SET facility_name = :facility_name,  facility_address1 = :facility_address1, facility_address2 = :facility_address2, facility_city = :facility_city, facility_province = :facility_province, facility_postal_code = :facility_postal_code, facility_country = :facility_country, facility_phone = :facility_phone WHERE facility_id = :facility_id');

        $this->db->bind(':facility_name', $data['facility_name']);
        $this->db->bind(':facility_address1', $data['facility_address1']);
        $this->db->bind(':facility_address2', $data['facility_address2']);
        $this->db->bind(':facility_city', $data['facility_city']);
        $this->db->bind(':facility_province', $data['facility_province']);
        $this->db->bind(':facility_postal_code', $data['facility_postal_code']);
        $this->db->bind(':facility_country', $data['facility_country']);
        $this->db->bind(':facility_phone', $data['facility_phone']);
        $this->db->bind(':facility_id', $data['facility_id']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function deleteFacility($data) {
        $this->db->query('SELECT * FROM products WHERE facility_id = :facility_id');
        $this->db->bind(':facility_id', $data['facility_id']);

        if($this->db->rowCount() == 0){
            $this->db->query('DELETE FROM facilities WHERE facility_id = :facility_id');

            $this->db->bind(':facility_id', $data['facility_id']);

            if($this->db->execute()) {
                return true;
            } else {
                return false;
            }
        } elseif ($this->db->rowCount()>0){
            return false;
        }

    }


    public function saveCompanyAsFacility($data) {
        $this->db->query('INSERT INTO facilities (facility_name, facility_address1, facility_address2, facility_city, facility_province, facility_postal_code, facility_country, facility_phone, company_id) VALUES (:company_name, :company_address1, :company_address2, :company_city, :company_province, :company_postal_code, :company_country, :company_phone, :company_id)');

        $this->db->bind(':company_name', $data['company_name']);
        $this->db->bind(':company_address1', $data['company_address1']);
        $this->db->bind(':company_address2', $data['company_address2']);
        $this->db->bind(':company_city', $data['company_city']);
        $this->db->bind(':company_province', $data['company_province']);
        $this->db->bind(':company_postal_code', $data['company_postal_code']);
        $this->db->bind(':company_country', $data['company_country']);
        $this->db->bind(':company_phone', $data['company_phone']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }

    }


//get all facilities (get which company they belong too)
//get one facility
//edit facility
//add facility
//delete facility
