<?php
//get all ingredients in company
//get all ingredients
//get one ingredient
//add ingredient
//delete ingredient
//edit ingredient

class Ingredient{
    private $db;

    public function __construct(){
        $this->db = new Database;
    }
    // get all ingredients from all companies guard it so only available to the vaad
    public function viewIngredients(){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id ORDER BY ingredients.ingredient_eval_status');

        $results = $this->db->resultSet();
        return $results;
    }

    // get all ingredients that were not looked over
    public function viewWorkflowIngredients(){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredients.ingredient_eval_status IS NULL');

        $results = $this->db->resultSet();
        return $results;
    }

    //get all ingredients for one company
    public function viewCompanyIngredients($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredients.company_id = :company_id ORDER BY ingredients.ingredient_eval_status');
        $this->db->bind(':company_id', $data['company_id']);

        $results = $this->db->resultSet();
        return $results;
    }

    public function viewProductIngredients($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id INNER JOIN formulas ON ingredients.ingredient_id = formulas.ingredient_id WHERE formulas.product_id = :product_id ORDER BY ingredients.ingredient_eval_status');
        $this->db->bind(':product_id', $data['product_id']);

        $results = $this->db->resultSet();
        return $results;
    }

    // get one ingredient
    public function viewIngredient($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredient_id = :ingredient_id');
        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        $results = $this->db->single();
        return $results;
    }

    // add an ingredient
    public function createIngredient($data){
        $this->db->query('SELECT * FROM ingredients WHERE ingredient_name =:ingredient_name && vendor_name = :vendor_name');
        $this->db->bind(':ingredient_name', $data['ingredient_name']);
        $this->db->bind(':vendor_name', $data['vendor_name']);

        if($this->db->resultSet()){
            return false;
        } else {

            $this->db->query('INSERT INTO ingredients (ingredient_name, vendor_name, company_id) VALUES (:ingredient_name, :vendor_name, :company_id)');

            $this->db->bind(':ingredient_name', $data['ingredient_name']);
            $this->db->bind(':vendor_name', $data['vendor_name']);
            $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }
}

    // edit ingredient info
    public function editIngredientInfo($data){
        $this->db->query('UPDATE ingredients SET ingredient_name = :ingredient_name, vendor_name = :vendor_name, ingredient_eval_status = 0, ingredient_eval_date = NULL, user_id = null WHERE ingredient_id = :ingredient_id');

        $this->db->bind(':ingredient_name', $data['ingredient_name']);
        $this->db->bind(':vendor_name', $data['vendor_name']);
        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    //evaluate the ingredient
    public function editIngredientStatus($data){
        $this->db->query('UPDATE ingredients SET ingredient_eval_status = :ingredient_eval_status, ingredient_eval_date = :ingredient_eval_date, ingredient_note = :ingredient_note, user_id = :user_id WHERE ingredient_id = :ingredient_id');

        $this->db->bind(':ingredient_eval_status', $data['ingredient_eval_status']);
        $this->db->bind(':ingredient_eval_date', $data['ingredient_eval_date']);
        $this->db->bind(':ingredient_note', $data['ingredient_note']);
        $this->db->bind(':user_id', $data['user_id']);
        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    public function editIngredientNote($data){
        $this->db->query('UPDATE ingredients SET ingredient_note = :ingredient_note, user_id = :user_id WHERE ingredient_id = :ingredient_id');

        $this->db->bind(':ingredient_note', $data['ingredient_note']);
        $this->db->bind(':user_id', $data['user_id']);
        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    public function deleteIngredient($data){
        $this->db->query('SELECT * FROM formulas WHERE ingredient_id = :ingredient_id');

        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        if($this->db->rowCount() == 0){
            $this->db->query('DELETE from ingredients WHERE ingredient_id = :ingredient_id');
            $this->db->bind(':ingredient_id', $data['ingredient_id']);
            if($this->db->execute()){
                return true;
            } else {
                return false;
            }
        } elseif ($this->db->rowCount()>0){
            return false;
        }
    }

    public function createProductAsIngredient($data){
        $this->db->query('INSERT INTO ingredients (ingredient_name, vendor_name, company_id) VALUES (:product_name, :company_name, :company_id)');

        $this->db->bind(':product_name', $data['product_name']);
        $this->db->bind(':company_name', $data['company_name']);
        $this->db->bind(':company_id', $data['company_id']);

        if($this->db->execute()){
            return true;
        } else {
            return false;
        }
    }

    public function findIngredient($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredient_name LIKE :ingredient_name ORDER BY ingredients.ingredient_eval_status');
        $this->db->bind(':ingredient_name', '%' . $data['ingredient_name'] . '%');

        $results = $this->db->resultSet();
        return $results;
    }

    public function findIngredientById($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredient_id = :ingredient_id ORDER BY ingredients.ingredient_eval_status');
        $this->db->bind(':ingredient_id', $data['ingredient_id']);

        $results = $this->db->resultSet();
        return $results;
    }

    public function findCompanyIngredient($data){
        $this->db->query('SELECT ingredients.*, companies.company_name FROM ingredients INNER JOIN companies ON companies.company_id = ingredients.company_id WHERE ingredient_name LIKE :ingredient_name && ingredients.company_id = :company_id ORDER BY ingredients.ingredient_eval_status');
        $this->db->bind(':ingredient_name', '%' . $data['ingredient_name'] . '%');
        $this->db->bind(':company_id', $data['company_id']);

        $results = $this->db->resultSet();
        return $results;
    }

}