<?php
//get all Private Label for one company
//get one Private Label
//edit Private Label
//add Private Label
//delete Private Label

class PrivateLabel
{
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }

    //get all facilities for one company
    public function viewCompanyPrivateLabels($data)
    {
        $this->db->query('SELECT pl_companies.*, companies.company_name FROM pl_companies INNER JOIN companies ON companies.company_id = pl_companies.company_id WHERE companies.company_id = :company_id');
        $this->db->bind(':company_id', $data['company_id']);

        $results = $this->db->resultSet();
        return $results;
    }

    public function viewPrivateLabels() {
        $this->db->query('SELECT pl_companies.*, companies.company_name FROM pl_companies INNER JOIN companies ON companies.company_id = pl_companies.company_id');

        $results = $this->db->resultSet();
        return $results;
    }

    public function  viewPrivateLabel($data) {
        $this->db->query('SELECT pl_companies.*, companies.company_name FROM pl_companies INNER JOIN companies ON companies.company_id = pl_companies.company_id WHERE pl_id = :pl_id');

        $this->db->bind('pl_id', $data['pl_id']);

        $results = $this->db->single();

        return $results;
    }

    public function createPrivateLabel($data) {
        $this->db->query('INSERT INTO pl_companies (pl_name, pl_address1, pl_address2, pl_city, pl_province, pl_postal_code, pl_country, pl_phone, pl_fax, pl_email, pl_website, pl_brand, company_id) VALUES (:pl_name, :pl_address1, :pl_address2, :pl_city, :pl_province, :pl_postal_code, :pl_country, :pl_phone, :pl_fax, :pl_email, :pl_website, :pl_brand, :company_id)');

        $this->db->bind('pl_name', $data['pl_name']);
        $this->db->bind('pl_address1', $data['pl_address1']);
        $this->db->bind('pl_address2', $data['pl_address2']);
        $this->db->bind('pl_city', $data['pl_city']);
        $this->db->bind('pl_province', $data['pl_province']);
        $this->db->bind('pl_postal_code', $data['pl_postal_code']);
        $this->db->bind('pl_country', $data['pl_country']);
        $this->db->bind('pl_phone', $data['pl_phone']);
        $this->db->bind('pl_fax', $data['pl_fax']);
        $this->db->bind('pl_email', $data['pl_email']);
        $this->db->bind('pl_website', $data['pl_website']);
        $this->db->bind('pl_brand', $data['pl_brand']);
        $this->db->bind('company_id', $data['company_id']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function editPrivateLabel($data) {
        $this->db->query('UPDATE pl_companies SET pl_name = :pl_name, pl_address1 = :pl_address1, 
                          pl_address2 = :pl_address2, pl_city = :pl_city, pl_province = :pl_province,
                          pl_postal_code = :pl_postal_code, pl_country = :pl_country, pl_phone = :pl_phone, 
                          pl_fax = :pl_fax, pl_email = :pl_email, pl_website = :pl_website, pl_brand = :pl_brand
                          WHERE pl_id = :pl_id');
        $this->db->bind('pl_name', $data['pl_name']);
        $this->db->bind('pl_address1', $data['pl_address1']);
        $this->db->bind('pl_address2', $data['pl_address2']);
        $this->db->bind('pl_city', $data['pl_city']);
        $this->db->bind('pl_province', $data['pl_province']);
        $this->db->bind('pl_postal_code', $data['pl_postal_code']);
        $this->db->bind('pl_country', $data['pl_country']);
        $this->db->bind('pl_phone', $data['pl_phone']);
        $this->db->bind('pl_fax', $data['pl_fax']);
        $this->db->bind('pl_email', $data['pl_email']);
        $this->db->bind('pl_website', $data['pl_website']);
        $this->db->bind('pl_brand', $data['pl_brand']);
        $this->db->bind('pl_id', $data['pl_id']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function deletePrivateLabel($data) {
        $this->db->query('SELECT * FROM products WHERE pl_id = :pl_id');
        $this->db->bind(':pl_id', $data['pl_id']);

        if($this->db->rowCount() == 0){
            $this->db->query('DELETE FROM pl_companies WHERE pl_id = :pl_id');

            $this->db->bind(':pl_id', $data['pl_id']);

            if($this->db->execute()) {
                return true;
            } else {
                return false;
            }
        } elseif ($this->db->rowCount()>0){
            return false;
        }

    }




}