<?php
// Models interact directly with database

//register contact
//register user

//need one function to make sure user exists

class SignUp {

    private $db;

    public function __construct() {
        $this->db = new Database;
    }

//Register Contact
    public function registerContact($data) {
    $this->db->query('INSERT INTO contacts (contact_first_name, contact_last_name, contact_title, contact_phone, contact_email, contact_username, contact_password, company_id) VALUES (:contact_first_name, :contact_last_name, :contact_title, :contact_phone, :contact_email, :contact_username, :contact_password, :company_id)');

     $this->db->bind(':contact_first_name', $data['contact_first_name']);
     $this->db->bind(':contact_last_name', $data['contact_last_name']);
     $this->db->bind(':contact_title', $data['contact_title']);
         $this->db->bind(':contact_phone', $data['contact_phone']);
     $this->db->bind(':contact_email', $data['contact_email']);
     $this->db->bind(':contact_username', $data['contact_username']);
     $this->db->bind(':contact_password', $data['contact_password']);
     $this->db->bind(':company_id', $data['company_id']);

     //execute
    if($this->db->execute()) {
        return true;
    } else {
        return false;
    }
    }

    public function findUserByUsername($username, $type) {
        switch ($type) {
            case 'contact':
                $sql = 'SELECT * FROM contacts WHERE contact_username = :username';
                break;
            case 'user':
                $sql = 'SELECT * FROM users WHERE username = :username';
                break;
            default:
                $sql = '';

        }
        $this->db->query($sql);

        //bind value
        $this->db->bind(':username', $username);

        //check row
        $this->db->single();
        if($this->db->rowCount()>0){
            return true;
        } else {
            return false;
        }

        }

    public function findCompanyCode($data)
    {
        $this->db->query('SELECT company_id FROM companies WHERE company_code = :company_code');

        $this->db->bind(':company_code', $data['company_code']);


//        if($this->db->rowCount() == 0) {
//            return false;
//
//        } else {
            $results = $this->db->resultSet();
            return $results;
//        }


    }

    public function registerUser($data) {
        $this->db->query('INSERT INTO users (username, user_password) VALUES (:username, :user_password)');

        $this->db->bind(':username', $data['username']);
        $this->db->bind(':user_password', $data['user_password']);

        if($this->db->execute()) {
            return true;
        } else {
            return false;
        }


    }

}